This category aims to achieve personalized federated learning by introducing self-supervised learning (SSL) to the training process. With SSL, an encoder model is trained to learn representations from unlabeled data. A higher performance can be achieved in subsequent tasks with the trained encoder. Only the encoder model is globally aggregated and shared during the regular training process. After reaching convergence, each client can download the trained global model to extract features from local samples.

---

### SimCLR

```bash
cd examples/ssl/simclr
uv run simclr.py -c ../configs/simclr_CIFAR10_resnet18.yml
```

**Reference:** Chen et al., "[A Simple Framework for Contrastive Learning of Visual Representations](https://arxiv.org/abs/2002.05709)," in Proc. ICML, 2020.

---

### BYOL

```bash
cd examples/ssl/byol
uv run byol.py -c ../configs/byol_CIFAR10_resnet18.yml
```

**Reference:** Grill et al., "[Bootstrap Your Own Latent A New Approach to Self-Supervised Learning](https://arxiv.org/pdf/2006.07733.pdf)," in Proc. NeurIPS, 2020.

---

### SimSiam

```bash
cd examples/ssl/simsiam
uv run simsiam.py -c ../configs/simsiam_CIFAR10_resnet18.yml
```

**Reference:** Chen et al., "[Exploring Simple Siamese Representation Learning](https://arxiv.org/pdf/2011.10566.pdf)," in Proc. CVPR, 2021.

---

### MoCoV2

```bash
cd examples/ssl/moco
uv run mocov2.py -c ../configs/mocov2_CIFAR10_resnet18.yml
```

**Reference:** Chen et al., "[Improved Baselines with Momentum Contrastive Learning](https://arxiv.org/abs/2003.04297)," in ArXiv, 2020.

---

### SwAV

```bash
cd examples/ssl/swav
uv run swav.py -c ../configs/swav_CIFAR10_resnet18.yml
```

**Reference:** Caron et al., "[Unsupervised Learning of Visual Features by Contrasting Cluster Assignments](https://arxiv.org/abs/2006.09882)," in Proc. NeurIPS, 2022.

---

### SMoG

```bash
cd examples/ssl/smog
uv run smog.py -c ../configs/smog_CIFAR10_resnet18.yml
```

**Reference:** Pang et al., "[Unsupervised Visual Representation Learning by Synchronous Momentum Grouping](https://arxiv.org/pdf/2006.07733.pdf)," in Proc. ECCV, 2022.

---

### FedEMA

```bash
cd examples/ssl/fedema
uv run fedema.py -c ../configs/fedema_CIFAR10_resnet18.yml
```

**Reference:** Zhuang et al., "[Divergence-Aware Federated Self-Supervised Learning](https://arxiv.org/pdf/2204.04385.pdf)," in Proc. ICLR, 2022.

### Calibre

```bash
cd examples/ssl/calibre
uv run calibre.py -c ../configs/calibre_CIFAR10_resnet18.yml
```

!!! note "note"
    Calibre is currently only supported on NVIDIA or M1/M2/M3 GPUs. To run on M1/M2/M3 GPUs, add the command-line argument `-m`.
